﻿/*==============================================================================================
   HTML Parsing Blocks. The following vars contain HTML code to be inserted in the Register
   Today HTML pages based on the business logic, e.g., whether the registration is for a company
   or individual, whether an old serial number is needed, whether State/Region/Province is 
   required, etc.

   (C) Copyright 2004 by Autodesk, Inc.  All rights reserved.
  ==============================================================================================*/

/////////////////////////////////////////////
// LOCALIZATION RESOURCES HERE:
/////////////////////////////////////////////

/////////////////////////////////////////////
// Product Language: 
//
// NOTE TO LOCALIZATION: The list below was inserted on 29 Jan 2001 and it was up to date at that point.
// You may use the codes detailed below if you are sure that these have not changed (they generally don't change), otherwise, 
// please check these before inserting the language code.
/////////////////////////////////////////////
//
//English - US and International:  (en-us)
//German:  (de)
//French:   (fr)
//Italian:   (it)
//Spanish:   (es)
//Czech:   (cs)             
//Hungarian:   (hu)
//Polish:   (pl)
//Russian:   (ru)
//Japanese:   (ja)
//Korean:   (ko)
//Traditional Chinese (Taiwan) :   (zh-tw)
//Simplified Chinese (PRC) :   (zh-cn)
//Brazilian Portuguese (pt-br)
//
/////////////////////////////////////////////

//////////////////////////////////////////////
///// Add as ECO17 Direct Addition to the Privacy Policy 
/////
var xmsgGatherInfoDuringInstall= "Tenga en cuenta que todos los datos recopilados durante la activación del producto se utilizan de acuerdo con Autodesk ";
var xmsgOfflinePrivacyWarning= "Si no está conectado a Internet, elija la codificación Selección automática en su navegador Internet Explorer (R) para ver la política de privacidad. Si puede acceder a Internet, la política de privacidad también se encuentra disponible en línea a través de autodesk.com."
////////////////////////////////////////////////////

var xmsgProductLanguage=	"es";

/////////////////////////////////////////////
// Disable field color
/////////////////////////////////////////////
var xmsgDisableColor=		"#7f7f7f";

var xmsgNavigationBGColor=	"#f4f4f4";
var xmsgNavigationDisableColor=	"#808080";

/////////////////////////////////////////////
// HTML FILE TITLE STRINGS
/////////////////////////////////////////////
var xmsgRTAuthConfirmed=				"Activación completa";
var xmsgRTActLicFound=                  "Se ha encontrado una licencia activada";
var xmsgRTActLicFoundError=            "Error de Registro - Activación"; 
var xmsgRTAuthEntryError=				"Error de entrada de activación";
var xmsgRTAuthError=					"Error de activación";
var xmsgRTAuthNow=						"Autorizar ahora";
var xmsgRTBeginReg=						"Opciones de activación";
var xmsgRTBuyInformation=				"Información de compra";
var xmsgRTConfirm=						"Confirmación de usuario";
var xmsgRTConnect=						"Se necesita conexión a Internet";
var xmsgRTConnectFail=					"Error de conexión";
var xmsgRTContactAutodesk=				"Póngase en contacto con Autodesk";
var xmsgRTCountryPage=					"País";
var xmsgRTEmail=						"Correo electrónico";
var xmsgRTFaxUS=						"Fax de usuario";
var xmsgRTMailUS=						"Correo de usuario";
var xmsgRTPurchaseOffline=				"Compra fuera de línea";
var xmsgRTRegConfirmed=					"Registro confirmado";
var xmsgRTExportConfirm=                "Confirmación de exportación de licencia";
var xmsgRTImportConfirm=                "Confirmación de importación de licencia"; 
var xmsgRTRegVol=						"Registro del producto";
var xmsgRTSUNDataConfirm=				"Confirmación de SUN Data";
var xmsgRTSUNServer=					"Servidor SUN";
var xmsgRTSUNSubmit=					"Confirmación de usuario/Enviar SUN";
var xmsgRTUserInfo=						"Información de usuario";
var xmsgRTLicFileSaveError=				"Error al guardar archivo de licencia de Flexlm";
var xmsgRTProductInfo=                   "Se necesita información de producto";
var xmsgNSARTBegin=						"Obtener una licencia de red";
var xmsgNSARTLocateLicense=				"Localizar archivo de licencia";
var xmsgNSARTEditServerAndSeat=			"Introducir o modificar información del servidor";
var xmsgNSARTConfirmServerAndSeat=		"Confirmar información del servidor";
var xmsgNSARTEnterSN=					"Introducir número de serie";
var xmsgProcessingError=				"Error de procesamiento";
var xmsgTimeout=        				"Esta sesión ha caducado";
var xmsgLicenseActivation=        		"Activando";
var xmsgLicenseTransfer=        		"Transferencia de licencias";

/////////////////////////////////////////////
// Software Information RESOURCES HERE:
/////////////////////////////////////////////
var xmsgActivationFor=	"Activación para:";
var xmsgPurchase=       "Compra:";
var xmsgRegistrationFor=       "Registro para:";
var xmsgProduct=	"Producto: ";
var xmsgsernum=		"Número de serie: ";
var xmsgsernumWGID=	"Número de serie: ";//modify by joyce.min on 2007-8-16
var xmsgprokeyWGID=  "Clave de producto: "; // add by  joyce.min on 2007-8-16
var xmsgOsernum=	"Número de serie anterior: ";
//var xmsgOprokey=      "Previous product key: "; // add by joyce.min on 2007-8-17
var xmsgOldSerialNum=	"Número de serie anterior:*";
var xmsgNewSernum1=	"Indique el número de serie o ID de grupo:"; //???
//var xmsgNewProkey1=
var xmsgRequestCode=	"Código de solicitud: ";
var xmsgRegAuthCode=	"Código de activación: ";
var xmsgApplicationKey=	"Clave de aplicación: ";
var xmsgRTHostID=				"ID de servidor principal:";
var xmsgRTFlexlmLicenseFile=	"Archivo de licencia:";

/////////////////////////////////////////////
// Primary Rolodex RESOURCES HERE:
/////////////////////////////////////////////
var xmsgSalutation=	"Tratamiento:";
var xmsgNone=		"(ninguno)";
var xmsgNotEntered=	"(no introducido)";
var xmsgFirstname=	"Nombre:";
//var xmsgFirstname= langCode+label.fname;
var xmsgFirstnameKanji=	"Nombre (Kanji):";
var xmsgFirstnameFurigana=	"Nombre (Zenkaku Kana):";
var xmsgLastname=	"Apellidos:";
var xmsgLastnameKanji=	"Apellidos (Kanji):";
var xmsgLastnameFurigana=	"Apellidos (Zenkaku Kana):";
var xmsgCompanyName=	"Nombre de empresa:*";
var xmsgCompanyName2=	"Nombre de empresa:";
var xmsgCompanyNameJP=	"Nombre de la empresa (Kanji):";
var xmsgPhone=		"Teléfono:";
var xmsgArea=		"Área:";
var xmsgNumber=		"Número:";
var xmsgExt=		"Extensión:";
var xmsgFax=		"Fax:";
var xmsgFaxTo=		"Enviar por fax a ";
var xmsgEmail=		"Email:";
var xmsgEmailTo=	"Enviar por correo electrónico a ";
var xmsgAddress=	"Dirección:";
var xmsgAddress2=	"Dirección 2:";
var xmsgAddress3=	"Dirección 3:";
var xmsgJPAddress=	"Población:";
var xmsgJPAddress2=	"Dirección:";
var xmsgJPAddress3=	"Nombre del edificio (y número de apartamento):";
var xmsgCity=		"Ciudad:";
var xmsgSRP=		"Estado/Región/Provincia:";
var xmsgStText=		"Estado:";
var xmsgPrText=		"Provincia:";
var xmsgRegText=	"Región:";
var xmsgPrefectureText=	"Prefectura:";
var xmsgCountyText=	"Condado:";
var xmsgCantonText=	"Cantón:";
var xmsgZipCode=	"Código postal:";
var xmsgPostCode=	"Código postal:";
var xmsgCountry=	"País o región:";
var xmsgDealer=		"Nombre de distribuidor autorizado de Autodesk:";
var xmsgMailTo=		"Enviar por correo a ";
var xmsgAnEmail=	"una dirección de correo electrónico";
var xmsgAFax=		"un número de fax";
var xmsgAMailAddress=	"una dirección de correo";
var xmsgPostalMail=		"Dirección postal";

///////////////////////////////////////////////
// Button RESOURCES HERE:
///////////////////////////////////////////////
var xmsgBack=			"Atrás";
var xmsgCancel=			"Cerrar";
var xmsgNext=			"Siguiente";
var xmsgPrint=			"Imprimir";
var xmsgPrintForm=		"Abrir formulario de solicitud de activación";
var xmsgNo=				"No";
var xmsgYes=			"Sí";
var xmsgBrowse=			"Examinar";
var xmsgDone=			"Terminado";
var xmsgOK=				"Aceptar";
var xmsgClose=			"Cerrar";
var xmsgSubmit=			"Enviar";
var xmsgFinish=			"Terminar";
var xmsgReset=			"Borrar todo";

///////////////////////////////////////////////
// Registration User Prompt RESOURCES HERE:
///////////////////////////////////////////////
var xmsgPleaseSelect=		"Seleccione ";
var xmsgPleaseSelect2=		"Para activar la licencia de %1 inmediatamente, seleccione \"Conectar ahora y activar\” de nuevo. Si continúa teniendo problemas de activación y ya ha solicitado y recibido un código de activación de Autodesk, seleccione \"Tengo un código de activación de Autodesk\".";
var xmsgSelectCountry=		"País o región en el que se usará el producto:";
var xmsgSelectCountry2=		"País o región:";
var xmsgInformation=		"Información";
var xmsgCompanyInfo=		"Información de la empresa:";
var xmsgContactInfo=		"Información de contacto:";
var xmsgResponseMethodInfo=	"Información del método de respuesta:"; //modify as the Spec. recommond by joyce.min on 2007-8-17
var xmsgFormSubmitMethodInfo=	"Método de envío del formulario:";
var xmsgConfirmInfo=		"Confirmar información";
var xmsgConfirmInfoTxt=		"Revise la siguiente información. Haga clic en uno de los vínculos de método de envío de formulario para continuar con la información que se muestra o haga clic en Atrás para realizar cambios.";
var xmsgConfirmCustIDInfoTxt=		"Confirme la siguiente información. Haga clic en Siguiente para continuar o Anterior para realizar cambios.";
var xmsgCountryHdr=			"Registro del producto";
var xmsgCountryRegTo=		"Este producto se registrará para:";
var xmsgCountryComp=		"Empresa";
var xmsgCountryIndiv=		"Individual";
var xmsgCountryUpgrade=		"Es una actualización";
var xmsgCountryUpgDetail=	"(Si es un cliente suscriptor, haga clic en No)";
var xmsgConnectHdr1=		"Conectando";
var xmsgConnectHdr2 = "Activación de la licencia de producto…";
var xmsgConnectHdr = "Se necesita conexión a Internet";
var xmsgConnectMsg=		"Conexión";
var xmsgConnectTxt=		"No se ha detectado ninguna conexión a Internet. Para activar en línea, conéctese ahora a Internet. Cuando tenga conexión, haga clic en Siguiente.";
var xmsgConnectTxtOLT=    "No se ha detectado ninguna conexión a Internet. Para transferir una licencia, conéctese ahora a Internet.";
var xmsgConnectTxt2=	"Cuando se haya establecido una conexión a Internet, haga clic en Siguiente.";
var xmsgConnectTxt3=	"Si no puede acceder a Internet, use un método sin conexión para solicitar un código de activación de Autodesk.";
var xmsgConnectWarming=	"El envío de esta información puede requerir unos minutos. Espere.";
var xmsgTryAgain=		"Inténtelo de nuevo";
var xmsgReEnterOld=		"Vuelva a introducir el número de serie anterior";
var xmsgNewSernum3=		"Introduzca el nuevo número de serie y pulse Siguiente.";
var xmsgNewSernum4=		"El software de prueba se ha instalado con un número de serie (000-00000000) que no puede registrarse. Si ha adquirido una copia del programa, habrá recibido un nuevo número de serie. Debe utilizar este número de serie para activar y habilitar el producto.";
var xmsgNewSernum5=		"Nuevo número de serie:"; //modify by joyce.min on 2007-8-16
var xmsgProductKey=      "Nueva clave de producto:"; //modify by joyce.min on 2007-8-16
var xmsgNewSernum6=		"Confirmar nuevo número de serie:";
var xmsgNewSernum8=		"Vuelva a introducir su antiguo número de serie";
var xmsgUseOtherMethod=		"Use otro método de registro";
var xmsgContactAutodesk=	"Póngase en contacto con Autodesk";
var xmsgContactAutodeskLink="Para ponerse en contacto con Autodesk, haga clic en el vínculo siguiente:";
var xmsgContactOptions=		"las opciones de contacto se muestran a continuación.";

var xmsgPuchaseInfo1=		"Información de compra";
var xmsgPuchaseInfo2=		"Ha seleccionado comprar en línea."; //modify as the LF1_Spec_SCV commend on p99 by joyce.min
var xmsgPuchaseInfo3=		"Pulse el botón Siguiente para continuar, o Cancelar si no desea continuar."; //modify as the LF1_Spec_SCV commend on p99 by joyce.min

var xmsgRegTitle=		"Registro - Activación";
var xmsgRegTitleBuy=		"Comprar productos de Autodesk en línea";
var xmsgRegTitleNSA=		"Activación de licencia de red";
var xmsgRegInfo=		"Información de clientes";
var xmsgRegInfo2=		"Método de registro";
var xmsgRegInfo3=		"Seleccione un método de registro y pulse Siguiente.";
var xmsgRegmethod1=		"Conectar directamente vía Internet";
var xmsgRegmethod3=		"Deseo recibir mi código de activación por:";
var xmsgRegmethod5=		"Correo";
var xmsgRegmethod6=		"Pulse Imprimir y envíe este impreso por correo a:";
var xmsgRegmethod7=		"Fax";
var xmsgRegmethod8=		"Para imprimir un formulario que pueda enviar por fax a Autodesk al %1, elija primero el método por el que desea recibir el código de activación. A continuación, haga clic en Imprimir y envíe este formulario por fax.";
var xmsgRegmethod9=		"Correo electrónico";
var xmsgRegmethod10NSA=		"La información de registro y servidor de licencias (mostrada a continuación) se ha guardado automáticamente en un archivo.";
var xmsgRegmethod10=		"La información de registro se ha guardado en el archivo siguiente, el cual se utilizará para completar el proceso de correo electrónico (no modifique este archivo):";
var xmsgRegmethod11NSA=		"Envíe por correo electrónico el archivo de información de registro y servidor de licencias %1 a %2.";
var xmsgRegmethod11=		"Envíe por correo electrónico el archivo de información de registro %1 a %2.";
var xmsgRegmethod12=		"Asegúrese de no modificar el archivo.<p>Se recomienda imprimir una copia de esta página y guardarla en un lugar seguro. Necesitará esta información para completar manualmente el proceso de correo electrónico.<p>Puede imprimir una copia de esta información para sus registros. Haga clic en Terminado para cerrar esta aplicación.";
var xmsgRegmethod13=		"Para adjuntar automáticamente y enviar %1 a Autodesk, haga clic en el vínculo siguiente.";
var xmsgRegmethod14=		"Enviar mi solicitud por correo electrónico";
var xmsgRegmethod15=		"Nota: La dirección de correo electrónico está automatizada. No envíe comunicaciones de correo electrónico a esta dirección.";
var xmsgRegmethod16=		"Para registrarse por fax o por correo, haga clic en uno de los vínculos siguientes:";
var xmsgRegmethod17=		"Error al enviar correo electrónico";
var xmsgRegmethod18NSA=		"Se ha producido un error cuando el sistema intentaba enviar automáticamente la información de registro y servidor de licencias.";
var xmsgRegmethod18=		"Se ha producido un error cuando el sistema intentaba enviar automáticamente la información de registro.";
var xmsgRegmethod19=		"Para enviar el archivo por correo electrónico manualmente:";
var xmsgRegmethod20NSA=		"Envíe por correo electrónico el archivo de información de registro y servidor de licencias %1 a %2.";
var xmsgRegmethod20=		"Envíe por correo electrónico el archivo de información de registro %1 a %2.";
var xmsgRegmethod21=		"Asegúrese de no modificar el archivo.<p>Se recomienda imprimir una copia de esta página y guardarla en un lugar seguro. Necesitará esta información para completar manualmente el proceso de correo electrónico.<p>Puede imprimir una copia de esta información para sus registros. Haga clic en Terminado para cerrar esta aplicación.";
var xmsgRegAuthInfo=		"Opciones de activación de licencia de producto";
var xmsgRegAuthInfo1=		"Confirmación de registro";
var xmsgRegExpConfirm=      "Confirmación de exportación de licencia";
var xmsgRegImpConfirm=      "Confirmación de importación de licencia";
var xmsgRegAuthInfo2 =      "Conectar ahora y activar (recomendado)";
var xmsgRegAuthInfo2Hover = "Conectar con Autodesk y activar inmediatamente la licencia de producto (se requiere una conexión a Internet)";
var xmsgRegAuthInfo3=		"Introducir código de activación"; 
var xmsgRegAuthInfo4=		"Seleccione una de las opciones siguientes:";
var xmsgRegAuthInfo4A =     "Tengo un código de activación de Autodesk";
var xmsgRegAuthInfo4AHoverA = "Introduzca el código de activación que ha solicitado y recibido de Autodesk.<br>Para simplificar este paso, pegue el código de activación completo en el primer cuadro. Los cuadros restantes se rellenarán automáticamente.";
var xmsgRegAuthInfo4AHoverB = "Especifique la ruta de archivo y el nombre o vaya al archivo de activación proporcionado por Autodesk como respuesta a su solicitud por correo electrónico.";
var xmsgRegAuthInfo4B=		"Introducir código de activación:"; 
var xmsgRegAuthInfo5=		"Seleccione el país o la región, introduzca el código de activación y haga clic en Siguiente.";
var xmsgRegAuthInfo6=		"Activación de licencia de producto";	
var xmsgRegAuthInfo7=		"%1 se ha activado correctamente.";
var xmsgRegAuthInfo8=		"Confirmación";		
var xmsgRegAuthInfo9=		"Gracias por registrar su producto de Autodesk. Esto nos permitirá prestarle un mejor servicio en el futuro.";
var xmsgRegAuthInfo10=		"Se ha guardado una copia de la información de activación en:";		
var xmsgRegAuthInfo10B=		"Se ha guardado una copia de la información de activación en:";
var xmsgRegAuthInfo14=		"Enhorabuena por la compra de %1. Según los términos de la licencia activada, puede ejecutar uno o varios productos en su equipo.";
var xmsgRegAuthInfo15=		"La desinstalación de %1 no elimina la licencia.";
var xmsgRegAuthInfo16=		"Licencia activa";
var xmsgRegActLicInfo=      "Se ha encontrado una licencia activada";
var xmsgRegActLicInfoError=      "Error de Registro - Activación";
var xmsgRegActiveInfo=        "Escriba el nombre del archivo de activación o localícelo:";
var xmsgRegActLicInfo1=       "Se ha encontrado en el equipo una licencia del producto previamente registrada y activada. Dicha licencia está en uso."
var xmsgRegActLicInfo1Error= "Se ha encontrado en el equipo una licencia del producto previamente registrada y activada.\n No obstante, se ha producido un error inesperado (%1). Cierre la aplicación y vuelva a intentarlo. Si el problema persiste, póngase en contacto con el administrador del sistema o con un distribuidor autorizado de productos de Autodesk.";

/////////////////////////////////////////////
// OLT Confirmation
/////////////////////////////////////////////
var xmsgExportSuccess=        "Exportación correcta"; //2008-01-16
var xmsgExportFail=           "Error de solicitud de exportación" ; //2008-01-16
var xmsgRegErrRef=            "Referencia del error:"; //2008-01-17
var xmsgImportSuccess=        "Importación correcta"; //2008-01-16
var xmsgImportFail=           "Error de solicitud de importación"; //2008-01-16
var xmsgExpSucessInfo=        "La licencia se ha exportado correctamente y se encuentra en el servidor de Autodesk."; //2008-01-16
var xmsgExpSuccessInfoHowtoImport=    "Cómo importar la licencia";
var xmsgExpSucessInfo1=        "Antes de iniciar el producto en el equipo de destino, utilice la utilidad Transferir licencia para importar esta licencia a ese equipo y tenga a mano el ID de usuario y la contraseña de Autodesk.";  //2008-01-16
var xmsgImpSucessInfo=         "La licencia se ha importado correctamente. Ya puede empezar a utilizar el producto. "; //2008-01-16
var xmsgImpRemindInfo=         "Recordatorio de exportación"; //2008-01-16
var xmsgImpRemindInfo1=        "Al activar esta casilla, cada vez que salga del programa aparecerá un cuadro de diálogo que le recordará que exporte la licencia.";//copy mockup 2008-01-16
var xmsgImpRemindInfo2=        "Resulta útil si va a importar la licencia a este equipo de manera temporal y necesita transferirla al equipo de origen.";//copy mockup 2008-01-16
var xmsgImpRemindInfo3=        "El recordatorio incluye la opción \"No volver a mostrar este mensaje\".";//copy mockup 2008-01-16
var xmsgOltTryAgain=           "Haga clic en el enlace \"Inténtelo de nuevo\" para volver a enviar la solicitud. ";
var xmsgImpFailMsg=            "Si el problema persiste, debe activar la licencia, en lugar de importarla.";

var xmsgReqfilelocMsg=       "El archivo de solicitud se encuentra en:";	//add by joyce.min on 2007-9-10 as Licensing Spec. recommend 	
var xmsgRegAuthInfo11=		"Gracias por registrarse. El producto ya se ha activado y el archivo de licencia se ha guardado. Haga clic en Imprimir si desea guardar una copia de esta información.";
var xmsgRegAuthInfo12=		"Pegar el código de activación.";
var xmsgRegAuthInfo13=		"Escribir el código de activación.";
var xmsgRegErrorActiveCode=    "<FONT color=red>Introduzca un código de activación para continuar.</FONT>";
var xmsgRegErrorActiveCode1=    "<FONT color=red>El código de activación no es válido. Compruebe los errores.</FONT>";
var xmsgRegErrorActiveFile=    "<FONT color=red>Introduzca la ruta de archivo de activación y el nombre para continuar.</FONT>";
var xmsgRegErrorSernum=      "<FONT color=red>Introduzca un número de serie para proseguir.</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorSernum1=      "<FONT color=red>El número de serie es demasiado corto.</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorProkey=      "<FONT color=red>Escriba la clave de producto para continuar.</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorProkey1=     "<FONT color=red>La clave de producto es demasiado corta.</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorHdr=		"Error de Registro - Activación";
var xmsgRegErrorSystem=		"Un problema temporal del sistema está causando errores en el registro. Haga clic en uno de los vínculos siguientes."
var xmsgRegErrorPrevReg=	"El número de serie introducido ya está registrado.";
var xmsgRegErrorMaxAuth=	"Ha superado el número de activaciones permitidas para este producto.";
var xmsgRegErrorMaxAuth2=	"Ha superado el número de licencias permitidas para este producto.";
var xmsgRegErrorInvalidOld=	"El número de serie que ha introducido para el producto anterior no es válido. Verifique que el número de serie anterior mostrado arriba es correcto. Haga clic en uno de los vínculos siguientes.";
var xmsgRegErrorData=		"Hay un problema con la información de registro proporcionada. Seleccione Inténtelo de nuevo para revisar y corregir la información introducida, utilice un método de registro diferente o póngase en contacto con Autodesk para continuar.";
var xmsgRegErrorNetwork=	"El producto que está intentando registrar tiene autorización de red y se debe instalar como tal. Desinstale el software y elija \"Red\" como tipo de instalación.<p>Consulte la sección sobre instalación en red del manual de instalación si desea conocer los procedimientos correctos de instalación y activación de la versión de red.";
var xmsgRegNoResponse=		"Un problema temporal está causando errores en el registro en línea. Haga clic en uno de los vínculos siguientes.";
var xmsgRegErrorAuthEntry=	"Hay un problema relacionado con el código de activación que ha introducido. Haga clic en uno de los vínculos siguientes.";
var xmsgRegErrorAuthPermission = "Para activar este producto de Autodesk debe tener permisos de administrador u obtener permisos superiores del administrador del sistema. Consulte con el administrador del sistema para obtener más información sobre los permisos de administrador y superiores.";							
var xmsgRegErrorAuth=		"Hay un problema relacionado con el código de activación. Haga clic en uno de los vínculos siguientes.";
var xmsgRegErrorFlex=		"Hay un problema relacionado con la licencia. Haga clic en uno de los vínculos siguientes.";
var xmsgRegConnError=		"Error de conexión";
var xmsgRegConnErrorTxt=	"Hay un problema relacionado con la conexión a Internet. Haga clic en uno de los vínculos siguientes.";
var xmsgRegPurchError3=		"Utilizar otro método de compra";
//modified as LFSpec_SCV commend by joyce.min
var xmsgRegPurchError5=		 "Gracias por comprar el software de Autodesk.<p>En este momento no hay disponible una conexión para completar el proceso, probablemente a causa de los parámetros del sistema.<p>Si hace clic en uno de los vínculos que aparecen a continuación, se abrirá el explorador y es posible que se establezca la conexión.<p>";

var xmsgAuthResellerMsg1=	"Realice la compra en su distribuidor local. Póngase en contacto con el distribuidor local para completar la compra.";

var xmsgLicSaveErrInfo=		"Se ha producido un error al guardar el archivo de licencia. Haga clic en uno de los vínculos siguientes.";

var xmsgOnlineStoreMsg1=	"Realice la compra en la tienda en línea de Autodesk. Si no encuentra en la tienda el producto que está buscando, póngase en contacto con un distribuidor autorizado.";
var xmsgOnlineStoreMsg2=    "Tienda en línea";
var xmsgAuthResellerMsg2=	"Distribuidor autorizado";
var xmsgLocateLicenseMsg1=	"Localizar archivo de licencia";
var xmsgLocateLicenseMsg2=	"Introduzca una ruta al archivo de licencia (o utilice Examinar para localizar una) y, a continuación, pulse Siguiente para continuar.";
var xmsgLocateLicenseMsg3=	"Archivo de licencia existente:";
var xmsgUserContactMsg=		"Debe introducir al menos uno de los siguientes:";
var xmsgFailureMsg=		    "No se ha podido procesar su solicitud de activación en línea.";

/////////////////////////////////////////////
// Default Ereg returned error messages
/////////////////////////////////////////////
var xmsgDefaultEregReturnedErrMsg=  "Su solicitud de activación en línea ha devuelto un error (%1) que no permite procesar la solicitud en nuestros sistemas automáticos.";
var xmsgRegErrorOnline=		"Haga clic en el vínculo \"Utilizar otro método\" siguiente para completar los formularios necesarios y enviar la solicitud al departamento de Autodesk Business Center local de su área. Un representante del servicio al cliente responderá en los 2 días laborables siguientes.";
var xmsgAnotherFormSubmitMethod=    "Utilizar otro método";
var xmsgOfflineRegistrationMethod=    "Solicitar código de activación usando un método sin conexión";
var xmsgOfflineRegistrationMethodHover= "Prepare una solicitud de código de activación para la licencia del producto y envíela a Autodesk por correo electrónico, teléfono o fax.";

/////////////////////////////////////////////
// Timeout message
/////////////////////////////////////////////
var xmsgTimeoutMsg1=    "La solicitud de activación en línea ha caducado."
var xmsgTimeoutMsg2=    "Haga clic en el vínculo \"Inténtelo de nuevo\" para volver a enviar la solicitud en línea. Si el problema continúa, puede hacer clic en el vínculo \"Utilizar otro método\" para completar los formularios necesarios y enviar la solicitud mediante correo electrónico, fax u otras opciones.";

/////////////////////////////////////////////
// Single User Network RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegSunData1=		"Datos de registro guardados";
var xmsgRegSunData2=		"Los datos de registro requeridos para la implantación del cliente se han guardado en ";
var xmsgRegSunData3=		"El número de serie anterior proporcionado para este registro de actualización no es válido. Póngase en contacto con el administrador.";
var xmsgRegSunData4=		"Este software se debe volver a instalar con un número de serie anterior válido.";
var xmsgRegSunData5=		"Implantación autónoma de varios puestos";
var xmsgRegSunData6=		"Para completar la implantación autónoma de varios puestos se requieren algunos datos de registro. Con las siguientes páginas podrá:";
var xmsgRegSunData7=		"Recopilar la información requerida.";
var xmsgRegSunData8=		"Introducir un número de serie anterior si se requiere para la actualización.";
var xmsgRegSunData9=		"Almacenar esta información en el servidor para la implantación de todas las instalaciones cliente.";
var xmsgRegSunData10=		"Este software se registrará con la siguiente información. Haga clic en Siguiente para continuar.";

/////////////////////////////////////////////
// Voluntary RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegVol1=	"Registro del producto";
var xmsgRegVol2=	"Seleccione una opción y haga clic en Siguiente:";
var xmsgRegVol3=	"Registrarse ahora: seleccione esta opción para iniciar el registro en línea";
var xmsgRegVol4=	"Registrarse más tarde: seleccione esta opción para ejecutar ahora el software";
var xmsgRegVol5=	"No volver a mostrar este mensaje.";
var xmsgRegVol6=	"(Si desea registrarse más tarde, puede seleccionar la opción de registro en el cuadro de diálogo Ayuda|Acerca de)";

/////////////////////////////////////////////
// Japan RESOURCES HERE:
/////////////////////////////////////////////
var xmsgCustIDMainTitle=	"Identificación de cliente";
var xmsgKatakana=		    "Nombre de la empresa (Zenkaku Kana):";
var xmsgDepartment=		    "Departamento:";
var xmsgDepartment2=		"Departamento:";

/////////////////////////////////////////////
// Autodesk Contact RESOURCES HERE:
/////////////////////////////////////////////
var xmsgFormWebHdr=	"En Internet:";
var xmsgFormWebDataMsg1 = "También puede solicitar un código de activación visitando:&nbsp;&nbsp;";
var xmsgFormEmailHdr=	"Email:";
var xmsgFormEmailData=	"";
var xmsgFormEmailDataBlock= "";
var xmsgFormEmailXMLData=	"";
var xmsgFormEmailXMLDataBlock= "";
var xmsgFormFaxHdr=		"Fax:";
var xmsgFormFaxHdrLocal=	"Oficina local de fax:";
var xmsgFormFaxHdrReg=	"Registro por fax:";
var xmsgFormFaxData=	"";
var xmsgFormFaxDataRegister=	"";
var xmsgFormCallHdr=	"Teléfono:";
var xmsgFormCallData=	"";
var xmsgFormMailHdr=	"Correo postal:";
var xmsgFormMailHdrLocal=	"Oficina local de correo:";
var xmsgFormMailHdrReg=	"Registro por correo:";
var xmsgFormMailData=	"";
var xmsgFormMailDataRegister=   "";
var xmsgFormPurchHdr=	"Comprar software";
var xmsgFormInternetMsg=    "Para utilizar el explorador web en la solicitud de un código de activación, haga clic en el vínculo."
var xmsgFormEmailMsg=       "Enviar por correo electrónico correspondencia y solicitudes de activación a:"

/////////////////////////////////////////////
// Privacy Statement RESOURCES HERE:
/////////////////////////////////////////////

var JPprivacystatement = "La información que proporcione será utilizada por Autodesk para registrar o autorizar su código de activación. Al registrarse accede a que Autodesk proporcione datos personales sobre usted relacionados con la gestión de licencias de productos y la verificación de autorizaciones a sus socios comerciales autorizados. Póngase en contacto con Autodesk en <a href=mailto:information@autodesk.jp>information@autodesk.jp</a> si prefiere que Autodesk no comparta a tal efecto dicha información personal con sus socios comerciales autorizados. Si desea corregir o actualizar su información de registro, haga clic <a %1>AQUÍ</a> para ponerse en contacto con Autodesk, o bien póngase en contacto con la oficina local de Autodesk.";
			
var privacystatement = "La información que proporcione será utilizada por Autodesk para registrar o autorizar su código de activación, mantenerle informado de productos y servicios, y garantizarle que se beneficia de las ventajas de ser un usuario autorizado de Autodesk. Autodesk no vende ni proporciona de ningún otro modo esta información a terceros ajenos a Autodesk ni a sus socios comerciales autorizados. Si desea corregir o actualizar la información de cliente registrado anterior, haga clic <a %1>AQUÍ</a> para ponerse en contacto con Autodesk, o bien póngase en contacto con la oficina local de Autodesk.";
				
			
/////////////////////////////////////////////
// Privacy Policy
/////////////////////////////////////////////
var xmsgPrivacyPolicy="Directiva de privacidad";

/////////////////////////////////////////////
// Copyright
/////////////////////////////////////////////
var xmsgCopyright="(c) Copyright 2009 Autodesk, Inc. Reservados todos los derechos."; //modify by joyce.min on 2007-8-14

/////////////////////////////////////////////
// Rebranding Message
/////////////////////////////////////////////
var xmsgRebranding="En la mayoría de los casos, el nuevo número de serie no se mostrará hasta que cierre el programa y lo reinicie con derechos de administrador.";
var xmsgRebranding2="Consulte la documentación del sistema operativo para obtener información sobre la forma de iniciar programas con derechos de administrador.";
/////////////////////////////////////////////
//  Note to Localization :
//
//	"InsertRegInfo" appears in RTUserInfo.html.  The full sentence in English is
//
//	"Fields marked in <FONT color=red>red</FONT> and with an asterisk (<FONT 
//	color=red>*</FONT>) are required to process your registration. Complete the form 
//	and click Next."
//
/////////////////////////////////////////////
var xmsgRegInfoMsg1= "Los campos marcados con <FONT color=red>*</FONT> son obligatorios.";
var xmsgRegInfoMsg2= "La información que introduce en esta página se almacena con la licencia. Se utiliza para la reactivación y las actualizaciones del producto. Asegúrese de introducir aquí información válida para evitar retrasos en el uso del producto.";

var xmsgLicLocationText1 = "Guarde el archivo de licencia para <b>%1</b> en:";

// Set Registration Info Header
var InsertRegInfo =     "<p><b>"+xmsgRegInfo+"</b></p>" +
			  "<p>" + xmsgRegInfoMsg1 + "</p>";


//=======================================================================
// Application Usage Information
//=======================================================================
var xmsgAppUsage=	"Preguntas:";

var xmsgAppUsageQ1=	"Para ayudar a Autodesk a comprender mejor las necesidades de su sector, le rogamos que responda a la siguiente pregunta.";
var xmsgAppUsageQ2=	"¿Cuál de las siguientes opciones describe mejor su esfera principal?";

var xmsgAppUsageOption51=	"Diseño de componentes aeroespaciales y de automoción ";
var xmsgAppUsageOption52=	"Diseño arquitectónico ";
var xmsgAppUsageOption53=	"Gestión de construcciones e instalaciones ";
var xmsgAppUsageOption54=	"Construcción de edificios: comercial ";
var xmsgAppUsageOption55=	"Construcción de edificios: residencial ";
var xmsgAppUsageOption56=	"Fabricación de equipamiento para la construcción ";
var xmsgAppUsageOption57=	"Ingeniería civil/Planificación del territorio ";
var xmsgAppUsageOption58=	"Diseño de equipamiento informático/médico/para oficina ";
var xmsgAppUsageOption67=	"Diseño de productos de consumo ";
var xmsgAppUsageOption59=	"Propiedad de edificios corporativos ";
var xmsgAppUsageOption92=	"Defensa ";
var xmsgAppUsageOption93=	"Diseño de controles eléctricos ";
var xmsgAppUsageOption94=	"Ingeniería de sistemas eléctricos ";
var xmsgAppUsageOption72=	"Ingeniería medioambiental ";
var xmsgAppUsageOption95=	"Productos metálicos fabricados ";
var xmsgAppUsageOption96=	"Diseño de interiores ";
var xmsgAppUsageOption97=	"Diseño de maquinaria ";
var xmsgAppUsageOption98=	"Fabricación: adquisiciones/ventas/marketing ";
var xmsgAppUsageOption40=	"Mapas y diseño geoespacial ";
var xmsgAppUsageOption41=	"Ingeniería de sistemas mecánicos (Aire acondicionado y calefacción y tuberías) ";
var xmsgAppUsageOption42=	"Ingeniería de sistemas de fontanería o de protección contra incendios ";
var xmsgAppUsageOption43=	"Diseño de plantas eléctricas y de procesamiento ";
var xmsgAppUsageOption44=	"Desarrollo inmobiliario ";
var xmsgAppUsageOption45=	"Ingeniería estructural ";
var xmsgAppUsageOption87=	"Telecomunicaciones ";
var xmsgAppUsageOption46=	"Herramientas y moldes/Tienda de maquinaria ";
var xmsgAppUsageOption47=	"Diseño de transportes ";
var xmsgAppUsageOption48=	"Servicios: electricidad, petróleo y gas ";
var xmsgAppUsageOption49=	"Servicios: agua y alcantarillado ";
var xmsgAppUsageOption99=	"Otros ";

var xmsgWrongCountryCodeMsg=	"Error: no se ha especificado un código de país conocido";

/////////////////////////////////////////////
// Version RESOURCES HERE:
/////////////////////////////////////////////
var xmsgVersion = "Versión:"

/////////////////////////////////////////////
// Access RTFax or RTMail through RTEmail
/////////////////////////////////////////////
var xmsgAccessFaxMsg=		"Enviaré mi solicitud por fax o teléfono"; //modify by joyce.min on 2007-10-18 as Licensing_Framework Spec_Frozen.doc recommend 
var xmsgAccessMailMsg=		"Registrarse por correo.";
var xmsgAccessHereMsg=		"aquí.";

/////////////////////////////////////////////
// Receive code by
/////////////////////////////////////////////
var xmsgReceiveCodeMsg=     "Desearía obtener el código mediante:";
var xmsgReceiveCodeMsg1=     "Recibiré el archivo de activación por correo electrónico"; //add by joyce.min on 2007-8-20
/////////////////////////////////////////////
// Messages for Ease of reauth or multi-seat client registration
/////////////////////////////////////////////
var xmsgNoDialogHdrMsg=		"Espere mientras se verifica <br>la licencia";
/////////////////////////////////////////////
//Resource for RTProductInfo
/////////////////////////////////////////////
var xmsgRTProductInfoTitle=      "Se necesita información de producto"; //add by joyce.min on 2007-8-14
var xmsgRTProductInfoMsg1=        "Para activar su licencia de %1, escriba el número de serie y la clave de producto que aparecen en el envoltorio del producto o el mensaje de correo electrónico de \"información sobre actualizaciones y licencias de Autodesk\".";
/////////////////////////////////////////////
//Error for RTProductInfo
/////////////////////////////////////////////
//var xmsgsernumError=        "Enter a serial number to proceed."; //add by joyce.min on 2007-8-17
//var xmsgprokeyError=        "Enter a product key to proceed." ; //add by joyce.min on 2007-8-17
/////////////////////////////////////////////
// Resource for NSA_RTBegin.html
/////////////////////////////////////////////
var xmsgNSARTBeginTitle=	"Obtener una licencia de red";
var xmsgNSARTBeginMsg1=		"Solicitar un archivo de activación de licencia de red mediante:";
var xmsgNSARTBeginMsg2=		"Conexión directa (a través de Internet)";
var xmsgNSARTBeginMsg3=		"Enviar la solicitud por correo electrónico, fax o teléfono";
var xmsgNSARTBeginNoInternet=	"";

/////////////////////////////////////////////
// Edit server and seat information
/////////////////////////////////////////////
var xmsgEditServerHdrMsg1=	"Información del servidor";
var xmsgEditServerHdrMsg2=	"Modelo de servidor de licencias*";
var xmsgEditServerMsg1=		"Introduzca la información del servidor de licencias. <br>"+
							"Haga clic en el botón Buscar para rellenar el campo ID del servidor principal.<p>";
var xmsgEditServerMsg2=		"Comenzar con datos del servidor principal de archivos de licencia existentes.";
var xmsgEditServerRemove=	"Eliminar";
var xmsgEditServerHostName=	"Nombre del servidor principal*";
var xmsgEditServerHostID=	"ID del servidor principal*";
var xmsgEditServerSeat=		"Puestos*";
var xmsgEditServerSingle=	"Servidor único";
var xmsgEditServerDistributed=	"Servidor distribuido";
var xmsgEditServerRedundant=	"Servidor redundante";
var xmsgEditServerDots=		"...";
var xmsgEditServerLookup=	"Buscar";
var xmsgEditServerAddServer=	"Añadir";
var xmsgEditServerRemoveServer=	"Eliminar";
var xmsgEditServerTotal=	"Total:";
var xmsgEditServerExceedMaxServer=	"Nota: Puede obtener licencias para un máximo de 20 servidores distribuidos a la vez. Si necesita licencias para más de 20 servidores, póngase en contacto con Autodesk.";
var xmsgEditServerSeatError=	"Los puestos sólo deben contener valores numéricos.";

var xmsgConfirmServerMsg=	"Revise la siguiente información. Haga clic en Siguiente para continuar o en Anterior para realizar cambios.";
var xmsgConfirmServerMsg2=	"Al hacer clic en Siguiente, esta información se enviará a Autodesk a través de Internet.";
var xmsgConfirmServerHdr2=	"Modelo de servidor de licencias:";
var xmsgConfirmServerHostName=	"Nombre del servidor principal";
var xmsgConfirmServerHostID=	"ID del servidor principal";
var xmsgConfirmServerSeat=		"Puestos";
var xmsgConfirmServerTotal=		"Puestos totales:";

var xmsgLicErrorHdr=			"Error de licencia"; 
var xmsgLicErrorInvalidSN=		"El número de serie especificado no es válido. Verifique que el número de serie mostrado arriba es correcto. Haga clic en uno de los vínculos siguientes.";
var xmsgLicReEnterSN=			"Vuelva a introducir el número de serie e inténtelo de nuevo.";

var xmsgLic113Msg2=				"El número total de puestos asignado a los servidores distribuidos supera ese número.";
var xmsgLic113ModifySeats=		"Modifique la distribución de puestos.";

var xmsgSaveLicenseHdr=			"Licencias recibidas";
var xmsgSaveLicenseMsg1=		"Se han recibido las licencias de Autodesk. Debe guardarlas en los archivos de licencia.<p> <b>Guarde las licencias en los archivos de licencia</b><p><LI>La <b>ubicación recomendada</b> para los archivos de licencia es un directorio \"License\" donde se haya instalado Autodesk Network License Manager en el servidor.&nbsp;&nbsp;";
var xmsgSaveLicenseMsg6=		"<LI>Si tiene un <b>archivo de licencia existente</b>, <b>inserte</b> la nueva licencia en el mismo.<br>Al hacer clic en Siguiente, el sistema insertará automáticamente la información de licencia en la ubicación adecuada en el archivo existente.</LI>";
var xmsgSaveLicenseMsg2=		"Si el archivo especificado anteriormente es un archivo de licencia existente:";
var xmsgSaveLicenseMsg3=		"Insertar la nueva información de licencia en el mismo.";
var xmsgSaveLicenseMsg4=		"Sobrescribir el archivo de licencia existente.";
var xmsgSaveLicenseMsg5=		"Corrija los siguientes errores:";

var xmsgSaveErrorFileNameTooLong=  "ERROR: El nombre de archivo introducido es demasiado largo.<br>" +
								"Cambie el nombre de archivo y continúe.";
var xmsgSaveErrorNoPermission=	"ERROR: No tiene permiso para guardar el archivo en la ubicación especificada.<br>Puede guardar el archivo en una ubicación temporal, obtener el permiso adecuado y cambiar la ubicación más tarde.";
var xmsgSaveErrorNoDiskSpace=	"ERROR: No dispone de espacio suficiente en disco para guardar el archivo en la ubicación especificada.<BR>Puede guardar el archivo en una ubicación temporal, conseguir espacio disponible y cambiar la ubicación más tarde.";
var xmsgSaveErrorInvalidFile=	"ERROR: La nueva licencia no se puede añadir al archivo especificado sin perder datos. El archivo especificado puede ser para equipos o modelos de servidor diferentes.<BR>Puede guardar el nuevo archivo de licencia con un nombre o una ubicación diferente y añadirlo al archivo manualmente más tarde.";															
var xmsgSaveErrorPathNotExit=	"ERROR: La ruta especificada no existe.<BR>Haga clic en el botón Examinar para localizar o crear la ruta.";
var xmsgSaveErrorPathBlank=		"ERROR: Debe especificar un nombre de archivo de licencia y una ruta válidos. Indique el nombre de archivo y la ruta en el campo siguiente o busque una ubicación.";

var xmsgLicAuthConfirmHdr1=		"Activación de licencia correcta";
var xmsgLicAuthConfirmHdr2=		"Información del servidor principal de licencias";
var xmsgLicAuthConfirmMsg1=		"Gracias por registrar su producto. Puede imprimir un registro de esta información.";
var xmsgLicAuthConfirmDate=		"Fecha:";

var xmsgLicPathMsg1=			"Los siguientes archivos de licencia se han guardado:";
var xmsgLicPathMsg2=			"Los archivos de licencia se han guardado en:";

var xmsgOtherMethodMsg1NSA=		"Utilizar otro método para obtener una licencia autorizada.";
var xmsgOtherMethodMsg1=		"Utilizar otro método.";

var xmsgContactAutodeskMsg1=	"Utilice uno de los métodos siguientes para ponerse en contacto con Autodesk.";
								
/////////////////////////////////////////////
// Email Options
/////////////////////////////////////////////
var xmsgEmailOptionNSATitle=	"Obtener un archivo de licencia por correo electrónico";
var xmsgEmailOptionTitle=		"Registrarse por correo electrónico";
var xmsgEmailOptionNSAMsg=		"La información de registro y servidor de licencias se ha guardado automáticamente en un archivo. El archivo debe enviarse al centro automatizado de procesamiento de registros de Autodesk.<p>Una vez que el archivo se haya enviado correctamente por correo electrónico a Autodesk, recibirá una respuesta automatizada, un archivo de licencia autorizado e instrucciones sobre cómo completar el proceso.";
var xmsgEmailOptionMsg=			"La información de registro se ha guardado automáticamente en un archivo. El archivo debe enviarse al centro automatizado de procesamiento de registros de Autodesk.<p>Una vez que el archivo se haya enviado correctamente por correo electrónico a Autodesk, recibirá una respuesta automatizada e instrucciones sobre cómo completar el proceso.";
var xmsgEmailOptionMsg2=		"Si el sistema de correo electrónico por defecto que utiliza está en condiciones de enviar inmediatamente un correo electrónico a través de Internet, haga clic en Enviar el archivo ahora y, a continuación, haga clic en Siguiente. El archivo se enviará automáticamente.<p>Si no dispone de acceso para enviar el correo electrónico en este momento, haga clic en Enviar el archivo más tarde. Obtendrá instrucciones para enviar el archivo manualmente.";
var xmsgEmailOptionInfo1=		"Enviar el archivo ahora.";
var xmsgEmailOptionInfo2=		"Enviar el archivo más tarde, manualmente.";
var xmsgEmailOptionInfo3=		"Enviar una copia de este correo electrónico a la dirección que proporcione.";

/////////////////////////////////////////////
// Email Error
/////////////////////////////////////////////
var xmsgEmailErrorHdr=			"No se puede crear correo electrónico";
var xmsgEmailErrorMsg1=			"Para completar el registro por correo electrónico, adjunte el archivo siguiente a un mensaje:";
var xmsgEmailErrorMsg2=			"Envíe el correo electrónico a %1.";
var xmsgEmailErrorMsg3=			"Puede encontrar el archivo en la ubicación siguiente:";

/////////////////////////////////////////////
// Local HERE customer information URLs
/////////////////////////////////////////////
var xmsgLocalHERETitle=			"Cambiar información de cliente";
var xmsgLocalHEREInfo=			"Para cambiar la información de cliente, póngase en contacto con un distribuidor autorizado de Autodesk o desplácese hasta el vínculo que aparece abajo aplicable a su país o región.";
var xmsgLocalHEREUS=			"América";
var xmsgLocalHEREEMEA=			"Europa, Oriente Medio, África";
var xmsgLocalHEREAPAC=			"Asia/Pacífico";

/////////////////////////////////////////////
// Help
/////////////////////////////////////////////
var xmsgHelpTitle=				"Ayuda";
var xmsgHelpUpgradeMsg=			"Si está registrando o activando una actualización de una versión anterior, debe activar esta casilla para que el sistema le solicite el número de serie de la versión que está actualizando.";
var xmsgHelpUpgradeRequiredTitle=	"Introduzca el número de serie del producto anterior (necesario para actualizar)";
var xmsgHelpUpgradeRequiredMsg=	"Se trata del número de serie de la versión de software anterior. Puede encontrar el número de serie en el cuadro de diálogo Ayuda > Acerca de del software o en el envoltorio del producto anterior.";

//	Fax or email error message
var xmsgNotEnterErrorMsg=		"No ha introducido %1. Indíquelo si desea recibir la activación por este método.";								

//  Help for serial number
var xmsgHelpSerialNumberTitle=  "Número de serie/ID de grupo"; ////modify by joyce.min on 2007-8-16
var xmsgHelpSerialNumberMsg=    "El número de serie se encuentra en el envoltorio del producto o en su correo electrónico de información de actualizaciones y licencias de Autodesk."; // ECO19

//  Help for ProductInfo serial number & Product Key //modify by joyce.min on 2007-8-16
var xmsgHelpProductKeyTitle=   "Clave de producto";
var xmsgHelpProductKeyMsg=    "La clave de producto está situada junto al número de serie en el envoltorio del producto o en su correo electrónico de información sobre actualizaciones y licencias de Autodesk."; // ECO19

/////////////////////////////////////////////
// The following strings are added back for backward competibility reason
/////////////////////////////////////////////
var xmsgRT0015TempSysErr=				"Error de conexión (0.15)";
var xmsgRT010203071213CannotCompErrA=	"Error de registro (1.2.3.7.12.13)";
var xmsgRT09AlreadyReg=					"Ya está registrado (9)";
var xmsgRT10ExceededAuths=				"Autorizaciones excedidas (10)";
var xmsgRT12StolenSN=					"Número de serie robado (12)";
var xmsgRT18OldSNInvalid=				"Número de serie anterior no válido (18)";
var xmsgRT20DataError=					"Error de datos (20)";
var xmsgRT21CustIDTelErr=				"Error de ID de cliente/teléfono (21)";
var xmsgRT22NetworkInstallation=		"Error de instalación en red (22)";
var xmsgRT900SystemNotResponding=		"El sistema no responde (900)";
var xmsgRTCustID=						"ID de cliente";
var xmsgRTCustIDConfirm=				"Confirmar identificación";
var xmsgRTNewSerialNumber=				"Información del nuevo número de serie";
var xmsgRTNoNewSN=						"Error de transacción de compra";
var xmsgRTPurchAuthFailed=				"Error de activación";
var xmsgRTPurchConfirmOther=			"Confirmación de compra";
var xmsgRTPurchConfirmPerm=				"Confirmación de compra: registrado y activado";
var xmsgRTPurchConfirmReg=				"Confirmación de compra: registrado pero no activado";
var xmsgRTPurchConfirmRegVol=			"Confirmación de compra: registrado";
var xmsgRTPurchConfirmRent=				"Confirmación de compra: registrado y alquiler activo";
var xmsgRTPurchConfirmUnReg=			"Confirmación de compra: no registrado ni activado";
var xmsgRTPurchConnectionFailed=		"Error de conexión de compra";
var xmsgRTPurchaseError=				"Error de compra";
var xmsgRTSNMismatch=					"Error de transacción de compra: número de serie no coincidente";
var xmsgRTSUNOldSNInvalid=				"Número de serie anterior no válido: SUN";

var szRTEmail =         "RTEmail.html";

var xmsgExit=			"Salir";

var xmsgCustIDMainTitle=	"Identificación de cliente";
var xmsgCustIDTitle1=		"ID de cliente:";
var xmsgCustIDText2=		"Escriba su ID de cliente y número de teléfono a continuación. Si no dispone de un ID de cliente, deje vacíos los dos campos.<p> ";
var xmsgCustIDText3=		"Nota: Si está volviendo a activar el producto, debe introducir un ID de cliente.";
var xmsgCustIDText3NSA=		"Nota: Si está volviendo a autorizar el producto, debe introducir un ID de cliente.";
var xmsgCustIDTitle2=		"Número de teléfono:";
var xmsgCustIDTelEx4=		"(ejemplo: 03-111-1234)";
var xmsgRegCustIDTel=		"El ID de cliente y el número de teléfono que ha especificado no coinciden con nuestros registros. Haga clic en uno de los vínculos siguientes.";

/////////////////////////////////////////////
//  Note to Localization :
//
//	"xmsgRT113SeatMsg1" appears in NSA_RT113TooManySeats.html.  The full sentence in English is
//
//	"Our records indicate that you have [Max allowed seats] valid [product name] seats available." 
/////////////////////////////////////////////
var xmsgRT113SeatMsg1=	"Nuestros registros indican que tiene %1 puestos válidos de %2 disponibles.<br>";

/////////////////////////////////////////////
// Error 12
/////////////////////////////////////////////
var xmsgErr12Hdr=				"El número de serie introducido no es válido";
var xmsgErr12APAC=				"<p>Este número de serie no es válido y no se puede activar. Póngase en contacto con nosotros en <a href=mailto:apacpl@listproc.autodesk.com target=\"_blank\">apacpl@listproc.autodesk.com</a></p>";
var xmsgErr12EMEA=				"<p>Estimado/a señor/señora</p><p>Gracias por intentar registrar su producto de software de Autodesk&#0174; o Discreet&#0153; en Autodesk.</p><p>Lamentablemente, nuestros registros indican que el número de serie que ha intentado registrar para su producto de software de Autodesk&#0174; o Discreet&#0153; no es válido o se trata del número de serie correspondiente a una copia pirata conocida de ese software y, por tanto, el producto de software de Autodesk&#0174; o Discreet&#0153; que está utilizando no dispone de autorización.</p><p>Las licencias para utilizar productos de software de Autodesk&#0174; se pueden adquirir a través de los distribuidores autorizados de Autodesk. Visite <a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a> para obtener una lista de distribuidores autorizados de Autodesk o acuda a una oficina de Autodesk de su zona. El uso de software legal es el único medio que le garantiza que obtendrá el máximo beneficio posible de su software Y evitará las posibles acciones civiles, e incluso criminales, derivadas del uso y la reproducción ilegal de software.</p><p>Las licencias para utilizar productos de software de Discreet&#0153; se pueden adquirir a través de los distribuidores autorizados de Discreet. Visite <a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a> para obtener una lista de distribuidores autorizados de Discreet o acuda a una oficina de Discreet de su zona. El uso de software legal es el único medio que le garantiza que obtendrá el máximo beneficio posible de su software Y evitará las posibles acciones civiles, e incluso criminales, derivadas del uso y la reproducción ilegal de software.</p><p>Por tanto, le rogamos que deje de utilizar inmediatamente el producto de software no autorizado que ha intentado registrar, elimine todas las copias almacenadas en cualquier unidad de hardware de su equipo y destruya todos los ejemplares en cualquier soporte que contengan este software. Aunque confiamos en que cumplirá voluntariamente esta solicitud, Autodesk se reserva sus derechos relacionados con este supuesto y puede transmitir sus detalles a la Business Software Alliance (“BSA”).</p><p>Si desea realizar alguna consulta o cree que ha recibido este mensaje por error, póngase en contacto con nosotros en: <a href=mailto:emea.register@activation.autodesk.com target=\"_blank\">emea.register@activation.autodesk.com</a></p><p>Si desea proporcionar información sobre el uso o la venta de software ilegal, póngase en contacto con su oficina local de Autodesk o con la BSA en <a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a></p><p>Gracias</p>";
var xmsgErr12US=				"<p>Estimado/a señor/señora</p><p>Recientemente ha intentado registrar un producto de software en Autodesk o Discreet.</p><p>Lamentablemente, nuestros registros indican que el número de serie que ha intentado registrar para su producto de software de Autodesk#0174; o Discreet&#0153; no es válido o se trata del número de serie correspondiente a una copia pirata conocida de ese software y, por tanto, el producto de software de Autodesk&#0174; o Discreet&#0153; que está utilizando no dispone de autorización.</p><p>Los usuarios de Autodesk pueden adquirir licencias para utilizar productos de software de Autodesk&#0174; a través de los distribuidores autorizados de Autodesk. Visite <a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a> para obtener una lista de los distribuidores autorizados de Autodesk en su zona. El uso de software legal es el único medio que le garantiza que obtendrá el máximo beneficio posible de su software Y evitará las posibles acciones civiles, e incluso criminales, derivadas del uso y la reproducción ilegal de software.</p><p>Los usuarios de Discreet&#0153; pueden adquirir licencias para utilizar productos de software de Discreet&#0153; a través de los distribuidores autorizados de Discreet. Visite <a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a> para obtener una lista de distribuidores autorizados de Discreet o acuda a una oficina de Discreet de su zona. El uso de software legal es el único medio que le garantiza que obtendrá el máximo beneficio posible de su software Y evitará las posibles acciones civiles, e incluso criminales, derivadas del uso y la reproducción ilegal de software.</p><p>Debe dejar de utilizar inmediatamente el producto de software no autorizado que ha intentado registrar, eliminar todas las copias almacenadas en cualquier unidad de hardware de su equipo y destruir todos los ejemplares en cualquier soporte que contengan este software. Aunque confiamos en que cumplirá voluntariamente esta solicitud, Autodesk se reserva sus derechos relacionados con este supuesto y puede transmitir sus detalles a la Business Software Alliance (“BSA”).</p><p>Si desea realizar alguna consulta o cree que ha recibido este mensaje por error, póngase en contacto con nosotros en: <a href=mailto:ProductActivation@activation.autodesk.com target=\"_blank\">ProductActivation@activation.autodesk.com</a></p><p>Si desea proporcionar información sobre el uso o la venta de software ilegal, póngase en contacto con su oficina local o con la BSA en <a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a></p><p>Gracias</p>";
// SIG // Begin signature block
// SIG // MIIVVAYJKoZIhvcNAQcCoIIVRTCCFUECAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFKWa6yrQsacx
// SIG // rOipoS1F3H10vj1OoIIRFjCCA3owggJioAMCAQICEDgl
// SIG // 1/r4Ya+e9JDnJrXWWtUwDQYJKoZIhvcNAQEFBQAwUzEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMSswKQYDVQQDEyJWZXJpU2lnbiBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBMB4XDTA3MDYxNTAwMDAwMFoX
// SIG // DTEyMDYxNDIzNTk1OVowXDELMAkGA1UEBhMCVVMxFzAV
// SIG // BgNVBAoTDlZlcmlTaWduLCBJbmMuMTQwMgYDVQQDEytW
// SIG // ZXJpU2lnbiBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIFNp
// SIG // Z25lciAtIEcyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
// SIG // iQKBgQDEtfJSFbyIhmApFkpbL0uRa4eR8zVUWDXq0TZe
// SIG // Yk1SUTRxwntmHYnI3SrEagr2N9mYdJH2kq6wtXaW8alK
// SIG // Y0VHLmsLkk5LK4zuWEqL1AfkGiz4gqpY2c1C8y3Add6N
// SIG // q8eOHZpsTAiVHt7b72fhcsJJwp5gPOHivhajY3hpFHut
// SIG // LQIDAQABo4HEMIHBMDQGCCsGAQUFBwEBBCgwJjAkBggr
// SIG // BgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24uY29t
// SIG // MAwGA1UdEwEB/wQCMAAwMwYDVR0fBCwwKjAooCagJIYi
// SIG // aHR0cDovL2NybC52ZXJpc2lnbi5jb20vdHNzLWNhLmNy
// SIG // bDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8B
// SIG // Af8EBAMCBsAwHgYDVR0RBBcwFaQTMBExDzANBgNVBAMT
// SIG // BlRTQTEtMjANBgkqhkiG9w0BAQUFAAOCAQEAUMVLyCSA
// SIG // 3+QNJMLeGrGhAqGmgi0MgxWBNwqCDiywWhdhtdgF/ojb
// SIG // 8ZGRs1YaQKbrkr44ObB1NnQ6mE/kN7qZicqVQh2wuceg
// SIG // jVfg+tVkBEI1TgHRM6IXyE2qJ8fy4YZMAjhNg3jG/FPg
// SIG // 6+AGh92klp5eDJjipb6/goXDYOHfrSjYx6VLZNrHG1u9
// SIG // rDkI1TgioTOLL4qa67wHIT9EQQkHtWUcJLxI00SA66HP
// SIG // yQK0FM9UxxajgFz5eT5dcn2IF54sQ6LKU859PfYqOrhP
// SIG // lAClbQqDXfleU/QYs1cPcMP79a2VoA4X3sQWgGDJDytu
// SIG // hgTx6/R4J9EFxe40W165STLyMzCCA8QwggMtoAMCAQIC
// SIG // EEe/GZXfjVJGQ/fbbUgNMaQwDQYJKoZIhvcNAQEFBQAw
// SIG // gYsxCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJu
// SIG // IENhcGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYD
// SIG // VQQKEwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0
// SIG // aWZpY2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0
// SIG // YW1waW5nIENBMB4XDTAzMTIwNDAwMDAwMFoXDTEzMTIw
// SIG // MzIzNTk1OVowUzELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMSswKQYDVQQDEyJWZXJpU2ln
// SIG // biBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqcqypMzN
// SIG // IK8KfYmsh3XwtE7x38EPv2dhvaNkHNq7+cozq4QwiVh+
// SIG // jNtr3TaeD7/R7Hjyd6Z+bzy/k68Numj0bJTKvVItq0g9
// SIG // 9bbVXV8bAp/6L2sepPejmqYayALhf0xS4w5g7EAcfrkN
// SIG // 3j/HtN+HvV96ajEuA5mBE6hHIM4xcw1XLc14NDOVEpkS
// SIG // ud5oL6rm48KKjCrDiyGHZr2DWFdvdb88qiaHXcoQFTyf
// SIG // hOpUwQpuxP7FSt25BxGXInzbPifRHnjsnzHJ8eYiGdvE
// SIG // s0dDmhpfoB6Q5F717nzxfatiAY/1TQve0CJWqJXNroh2
// SIG // ru66DfPkTdmg+2igrhQ7s4fBuwIDAQABo4HbMIHYMDQG
// SIG // CCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDov
// SIG // L29jc3AudmVyaXNpZ24uY29tMBIGA1UdEwEB/wQIMAYB
// SIG // Af8CAQAwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2Ny
// SIG // bC52ZXJpc2lnbi5jb20vVGhhd3RlVGltZXN0YW1waW5n
// SIG // Q0EuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA4GA1Ud
// SIG // DwEB/wQEAwIBBjAkBgNVHREEHTAbpBkwFzEVMBMGA1UE
// SIG // AxMMVFNBMjA0OC0xLTUzMA0GCSqGSIb3DQEBBQUAA4GB
// SIG // AEpr+epYwkQcMYl5mSuWv4KsAdYcTM2wilhu3wgpo17I
// SIG // ypMT5wRSDe9HJy8AOLDkyZNOmtQiYhX3PzchT3AxgPGL
// SIG // OIez6OiXAP7PVZZOJNKpJ056rrdhQfMqzufJ2V7duyuF
// SIG // PrWdtdnhV/++tMV+9c8MnvCX/ivTO1IbGzgn9z9KMIIE
// SIG // vzCCBCigAwIBAgIQQZGhWjl4389JZWY4HUx1wjANBgkq
// SIG // hkiG9w0BAQUFADBfMQswCQYDVQQGEwJVUzEXMBUGA1UE
// SIG // ChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsTLkNsYXNz
// SIG // IDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBB
// SIG // dXRob3JpdHkwHhcNMDQwNzE2MDAwMDAwWhcNMTQwNzE1
// SIG // MjM1OTU5WjCBtDELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2ln
// SIG // biBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBv
// SIG // ZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYSAoYykwNDEuMCwGA1UEAxMlVmVyaVNpZ24gQ2xh
// SIG // c3MgMyBDb2RlIFNpZ25pbmcgMjAwNCBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAL687rx+74Pr
// SIG // 4DdP+wMQOL4I0ox9nfqSfxkMwmvuQlKM3tMcSBMl6sFj
// SIG // evlRZe7Tqjv18JScK/vyZtQk2vf1n24ZOTa80KN2CB4i
// SIG // JyRsOJEn4oRJrhuKof0lgiwQMOhxqyjod0pR8ezN+PBU
// SIG // 1G/A420Kj9nYZI1jsi1OJ/aFDv5t4ymZ4oVHfC2Gf+hX
// SIG // j61nwjMykRMg/KkjFJptwoRLdmgE1XEsXSH6iA0m/R8t
// SIG // kSvnAVVN8m01KILf2WtcttbZqoH9X82DumOd0CL8qTtC
// SIG // abKOOrW8tJ4PXsTqLIKLKP1TCJbdtQEg0fmlGOfA7lFw
// SIG // N+G2BUhSSG846sPobHtEhLsCAwEAAaOCAaAwggGcMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwRAYDVR0gBD0wOzA5Bgtg
// SIG // hkgBhvhFAQcXAzAqMCgGCCsGAQUFBwIBFhxodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhMDEGA1UdHwQqMCgw
// SIG // JqAkoCKGIGh0dHA6Ly9jcmwudmVyaXNpZ24uY29tL3Bj
// SIG // YTMuY3JsMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEF
// SIG // BQcDAzAOBgNVHQ8BAf8EBAMCAQYwEQYJYIZIAYb4QgEB
// SIG // BAQDAgABMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFD
// SIG // bGFzczNDQTIwNDgtMS00MzAdBgNVHQ4EFgQUCPVR6Pv+
// SIG // PT1kNnxoz1t4qN+5xTcwgYAGA1UdIwR5MHehY6RhMF8x
// SIG // CzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwg
// SIG // SW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJp
// SIG // bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIQcLrk
// SIG // HRDZKTS2OMp7A8y6vzANBgkqhkiG9w0BAQUFAAOBgQCu
// SIG // Ohe4SntV+mRV7ECk7UlBkJmcibyvLh3KeCP5HBkPf+to
// SIG // vDLZiDje3D/TibQ/sYKW8aRauu0uJtPefAFuAAoApAaS
// SIG // EUgJQPkcGHlnIyTgu9XhUK4b9Q7d4C6BzYCjbFJPkXVV
// SIG // iroi8tLqQXWIL2NVfR5UWpVZytk0gcBfXvZ6tTCCBQkw
// SIG // ggPxoAMCAQICEHS8VusbS9oziV7CM3V8XDMwDQYJKoZI
// SIG // hvcNAQEFBQAwgbQxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVybXMg
// SIG // b2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
// SIG // bS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWduIENs
// SIG // YXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwHhcNMDkw
// SIG // MzEwMDAwMDAwWhcNMTAwNDA5MjM1OTU5WjCBzDELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCkNhbGlmb3JuaWExEzAR
// SIG // BgNVBAcTClNhbiBSYWZhZWwxFzAVBgNVBAoUDkF1dG9k
// SIG // ZXNrLCBJbmMuMSEwHwYDVQQLFBhQU0VCLUxpY2Vuc2lu
// SIG // ZyAmIEluc3RhbGwxPjA8BgNVBAsTNURpZ2l0YWwgSUQg
// SIG // Q2xhc3MgMyAtIE1pY3Jvc29mdCBTb2Z0d2FyZSBWYWxp
// SIG // ZGF0aW9uIHYyMRcwFQYDVQQDFA5BdXRvZGVzaywgSW5j
// SIG // LjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAmeyo
// SIG // XUqsM3gsliL4M1tThOIixcSmppT1AI04curyMTgKCrT6
// SIG // vIaC74ZsEki5wseN6FoAwzeZUJZWPbbPV0qekjTQySBs
// SIG // OYONAd1oU3S2a86Cujy+zxcfryQA+GqYZuG+j1SsLUy5
// SIG // ASBEv4zkQjfWpHMOI8JRdQr2RgVJ/C3LvFcCAwEAAaOC
// SIG // AX8wggF7MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeA
// SIG // MEAGA1UdHwQ5MDcwNaAzoDGGL2h0dHA6Ly9DU0MzLTIw
// SIG // MDQtY3JsLnZlcmlzaWduLmNvbS9DU0MzLTIwMDQuY3Js
// SIG // MEQGA1UdIAQ9MDswOQYLYIZIAYb4RQEHFwMwKjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYTATBgNVHSUEDDAKBggrBgEFBQcDAzB1BggrBgEF
// SIG // BQcBAQRpMGcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3Nw
// SIG // LnZlcmlzaWduLmNvbTA/BggrBgEFBQcwAoYzaHR0cDov
// SIG // L0NTQzMtMjAwNC1haWEudmVyaXNpZ24uY29tL0NTQzMt
// SIG // MjAwNC1haWEuY2VyMB8GA1UdIwQYMBaAFAj1Uej7/j09
// SIG // ZDZ8aM9beKjfucU3MBEGCWCGSAGG+EIBAQQEAwIEEDAW
// SIG // BgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0B
// SIG // AQUFAAOCAQEAEhMhyHuuFsZagEh6O0zAq+6z0EuhaaqI
// SIG // A/hY0xRjZSyBSoQGwwX1pcNyaFf4TTm/xobUutgT7Ct+
// SIG // l/Xl+RbntwVRkyMSKWGX4CtIKuR70vdqREuNEW9exz0M
// SIG // Ck+lZlPZupJe/OA9cZr1x2M296RHRXKK8lCaE5bexPD/
// SIG // k462NFYSZYfs0DwBMz9Ui+kiFcjnsnUpTGoAI7/Xg6Bn
// SIG // t7tzXU5emeIw9AIZt+64XKOvh5BL1VJ/WuD2rjqCwBBP
// SIG // 4NRD2cOa905LKi0qNHp9KyZPE8IJIK2XgTTX9L+Cw7mT
// SIG // Q2kmYtBmz/9/xjeIVrbwEqZeEfbLiSW2QRysH5RA7oou
// SIG // UjGCA6owggOmAgEBMIHJMIG0MQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsT
// SIG // FlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsT
// SIG // MlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJp
// SIG // c2lnbi5jb20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJp
// SIG // U2lnbiBDbGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENB
// SIG // AhB0vFbrG0vaM4lewjN1fFwzMAkGBSsOAwIaBQCggbQw
// SIG // GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
// SIG // BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcN
// SIG // AQkEMRYEFNhTVKIaq555sx7JV2/rv+zx28T/MFQGCisG
// SIG // AQQBgjcCAQwxRjBEoCaAJABBAHUAdABvAGQAZQBzAGsA
// SIG // IABDAG8AbQBwAG8AbgBlAG4AdKEagBhodHRwOi8vd3d3
// SIG // LmF1dG9kZXNrLmNvbSAwDQYJKoZIhvcNAQEBBQAEgYAp
// SIG // jAbWD+TX2m/IBo+aqvTwLJCJFeVawDF/OlVm/yLUPxYN
// SIG // 7zU696OS2r9/gzViwwrtRKzNetuS0FCI+mXLmMEXXaKD
// SIG // SE2z82Hm7AfitbkZmg+MPeQmRkVlTd91iJua/gapHR9L
// SIG // +cu4leUkVCpA00fEA3FG07YA1NKow60qAjt5EaGCAX8w
// SIG // ggF7BgkqhkiG9w0BCQYxggFsMIIBaAIBATBnMFMxCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjErMCkGA1UEAxMiVmVyaVNpZ24gVGltZSBTdGFtcGlu
// SIG // ZyBTZXJ2aWNlcyBDQQIQOCXX+vhhr570kOcmtdZa1TAJ
// SIG // BgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3
// SIG // DQEHATAcBgkqhkiG9w0BCQUxDxcNMDkxMTIwMDAwNzIx
// SIG // WjAjBgkqhkiG9w0BCQQxFgQUZaRBINNs25vHLW2GzZxn
// SIG // QRQc4FswDQYJKoZIhvcNAQEBBQAEgYC/omEvyTA1efNp
// SIG // oGXc29iFEBNRAcGbDcMFa/ozDQC9oOIM8yz/WXkTD48a
// SIG // +ngA0YQV+qu07jeqowrQFiLgZyeHz8vMQ/AvQVoHavPF
// SIG // nyTeJa1D2CRFpTp35Rk6cUSShxvWY7Bzz9pIez3QPGh0
// SIG // lM033r8ZSKrnGDjzb6Oqhry4Dg==
// SIG // End signature block
